program LJConsole;

//---------------------------------------------------------------------------
//
//  ljconsole
//
//  Port of the VC6 U12 example to demonstrate the U12 with Delphi
//  Calls AISample twice to read all 8 single-ended channels.
//
//	Requires LabJack U12 DLL V1.05 or later.
//
//  support@labjack.com
//  07/2010
//----------------------------------------------------------------------
//

{$APPTYPE CONSOLE}

uses
  SysUtils,
  ljackuwStdCall in '../ljackuwStdCall.pas';

var
  i : Integer;
  disableCal : Integer;
  ch : Char;
  errorcode : Integer;
  idnum : Integer;
  demo : Integer;
  stateIO : Integer;
  numCh : Integer;
  channels : tChannels;//array[0..3] of Integer;
  gains : tGains;//array[0..3] of Integer;
  ov : Integer;
  voltages : tVoltages;//array[0..3] of Single;
  updateIO : Integer;

begin

  // Variable initial values
  idnum := -1; // local ID, serial number, or -1 for first found.
  demo := 0; // Send 0 for normal operation, >0 for demo mode.  Demo mode allows
             // this function to be called without a LabJack.
  stateIO := 0; // Output states for IO0-IO3.
  numCh := 4; // Number of analog input channels to read (1,2, or 4).
  updateIO := 0; //If >0, state values will be written.  Otherwise, just a read is performed.
  disableCal := 0;

  // Array inital values
  for i := 0 to 3 do
  begin
    channels[i]:= i; // Array of channel commands with at least numChannels
                     // elements.  Each channel command is 0-7 for single-ended,
                     // or 8-11 for differential.

    gains[i] := 0;   // array of gain commands with at least numChannels
                     // elements.  Gain commands are 0=1, 1=2, , 7=20.  This
                     // amplification is only available for differential channels.

    voltages[i] := 0; // An array where voltage readings are returned.  Send a
                      // 4-element array of zeros.
  end;

  // Read AI 0-3
  errorcode := AISample (idnum,demo,stateIO,updateIO,1,numCh,channels,gains,disableCal,ov,voltages);
  Writeln('AISample error = ' + IntToStr(errorcode));
  Writeln('AI0 = ' + FloatToStr(voltages[0]));
  Writeln('AI1 = ' + FloatToStr(voltages[1]));
  Writeln('AI2 = ' + FloatToStr(voltages[2]));
  Writeln('AI3 = ' + FloatToStr(voltages[3]));

  // Check for overvoltage
  if ov > 0 then
    Writeln('overvoltage detected');

  // Put space in
  Writeln('');

  // Specify that we will read AI 4-7
  channels[0] := 4;
  channels[1] := 5;
  channels[2] := 6;
  channels[3] := 7;

  // Must reset voltage array to zeros
  for i := 0 to 3 do
    voltages[i] := 0;

  // Read AI 4-7
  errorcode := AISample (idnum,demo,stateIO,updateIO,1,numCh,channels,gains,0,ov,voltages);
  Writeln('AISample error = ' + IntToStr(errorcode));
  Writeln('AI4 = ' + FloatToStr(voltages[0]));
  Writeln('AI5 = ' + FloatToStr(voltages[1]));
  Writeln('AI6 = ' + FloatToStr(voltages[2]));
  Writeln('AI7 = ' + FloatToStr(voltages[3]));

  // Wait for key press
  ReadLn(ch);
end.
